#version 120
#extension GL_EXT_gpu_shader4 : enable
// added the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////


// from ShaderToy.com https://www.shadertoy.com/view/WllfzS
// Adapted for iStripper by WyldAnimal

uniform float u_Elapsed; 
uniform vec2 u_WindowSize; 

#define iTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

float Scale;
float map(vec3 p)
{
float s=2.;
for(int i = 0; i < 4; i++) {
p=mod(p-1.,2.)-1.;
float r2=1.2/dot(p,p);
p*=r2;
s*=r2;
}
Scale=log2(s);
p = abs(p)-0.8;
if (p.x < p.z) p.xz = p.zx;
if (p.y < p.z) p.yz = p.zy;
if (p.x < p.y) p.xy = p.yx;
return length(cross(p,normalize(vec3(0,.5,1))))/s-Scale*.0015;
}


///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, 
// it is a color and needs to be a vec4. // change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
vec2 uv=(2.*fragCoord-iResolution.xy)/iResolution.y;
vec3 p,
ro=vec3(1.,1.,iTime),
w=normalize(vec3(.1*sin(iTime*.5),.3,1)),
u=normalize(cross(w,vec3(cos(-iTime*.16),sin(-iTime*.16),0))),
rd=mat3(u,cross(u,w),w)*normalize(vec3(uv,2));
float h=0.,d,i;
for(i=1.;i<100.;i++)
{
p=ro+rd*h;
d=map(p);
if(d<.0001)break;
h+=d;
}
//fragColor.xyz=35.*vec3(vec3(.7,.9,.7)*cos(Scale*.3)+(cos(p.xyy)*.5+.5))/i; 
fragColor=vec4(35.*vec3(vec3(.7,.9,.7)*cos(Scale*.3)+(cos(p.xyy)*.5+.5))/i,1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; 
//gl_FragColor = vec4(cc);

}
 //sets the pixel to the value of vec4 cc and ..
// use the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.